<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use App\Models\User;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;

class AuthController extends Controller {
    // public function loginRequest( Request $request ) {
    //     $request->validate( [
    //         'email' => 'required',
    //         'password' => 'required',

    // ] );

    //     $credentials = $request->only( 'email', 'password' );

    //     if ( Auth::attempt( $credentials ) ) {

    //         $usersx = DB::table( 'users' )->where( 'email', $request->email )->get();

    //         if ( $usersx[ 0 ]->status == 5 ) {

    //             $showModal = true;
    //             return view( 'dashboard', compact( 'showModal' ) );

    //         } else {
    //             if ( ( Auth::user()->status === 0 && Auth::user()->created_at->gt( Carbon::now()->subHours( 12 ) ) ) ) {
    //                 //                               dd( $credentials );
    //                 $showModal = true;
    //                 return view( 'dashboard', compact( 'showModal' ) );
    //             } else if ( Auth::user()->status === 5 ) {
    //                 $showModal = true;
    //                 return view( 'dashboard', compact( 'showModal' ) );
    //             } else {
    //                 $showModal = false;
    //                 return redirect()->intended( 'dashboard' )
    //                 ->with( 'success', 'You have successfully logged in.' );
    //             }
    //         }

    //     }

    //     return redirect( 'signin' )->withSuccess( 'Oppes! You have entered invalid credentials' );

    // }

    public function loginRequest( Request $request ) {
        $validated = $request->validate( [
            'email' => 'required|email',
            'password' => 'required|string',
        ] );

        $credentials = $request->only( 'email', 'password' );
        $remember = $request->has( 'remember' );

        if ( !Auth::attempt( $credentials, $remember ) ) {
            return redirect()->route( 'signin' )
            ->withInput( $request->only( 'email', 'remember' ) )
            ->withErrors( [
                'email' => 'Invalid credentials. Please try again.',
            ] );
        }

        $user = Auth::user();

        // Handle account status checks
        if ( $this->shouldShowVerificationModal( $user ) ) {
            return view( 'dashboard', [ 'showModal' => true ] );
        }

        // Successful login for verified accounts
        return redirect()->intended( 'dashboard' )
        ->with( 'success', 'Welcome back, ' . $user->name . '!' );
    }

    /**
    * Determine if verification modal should be shown
    */
    protected function shouldShowVerificationModal( $user ): bool {
        // Account pending verification ( status = 5 )
        if ( $user->status === 5 ) {
            return true;
        }

        // New account within 12-hour grace period ( status = 0 )
        if ( $user->status === 0 && $user->created_at->gt( now()->subHours( 12 ) ) ) {
            return true;
        }

        return false;
    }

    public function setPassword( Request $request ) {

        $user = Auth::user();
        $user->password = Hash::make( $request->password );
        $user->status = 1;
        $user->save();

        return redirect()->route( 'signin' )->with( 'success', 'Password set successfully!' );

    }

    public function forgotPass( Request $request ) {

        $email = $request->email;
        $userExists = DB::table( 'users' )->where( 'email', $email )->exists();
        $loginUrl = route( 'signin' );

        if ( $userExists ) {
            $users = DB::table( 'users' )->where( 'email', $email )->get();
            DB::table( 'users' )->where( 'email', $email )->update( [ 'password' => Hash::make( 'majik@resetPwd' ), 'status'  => 5 ] );
            $user = $users[ 0 ];

            Mail::send(
                'emails.pass-reset',
                [
                    'loginUrl' => $loginUrl,
                    'userName' => $user->email,
                ],

                function ( $message ) use ( $user ) {
                    $message->to( $user->email )
                    ->subject( 'Majik Water! - Password Reset Notification' );
                }
            );
            return redirect()->back();

        } else {
            return redirect()->back();

        }

    }

    public function register( Request $request ) {
        $validated = $request->validate( [

            'fname' => 'required|string|max:255',
            'lname'=> 'required|string|max:255',
            'dept' => 'required',
            'phone' => 'required|string|max:255',
            'email'  => 'required|email|unique:users,email',
            'role' => 'required|string',

        ] );

        $user = User::create( [
            'fname' => $validated[ 'fname' ],
            'lname'=> $validated[ 'lname' ],
            'dept' => $validated[ 'dept' ],
            'phone' => $validated[ 'phone' ],
            'email'  => $validated[ 'email' ],
            'role'  => $validated[ 'role' ],
            'status'  => '0',
            'staffno'=> substr( md5( mt_rand() ), 0, 7 ),
            'password' =>  Hash::make( 'majik@123' ),
            'first_time_token' => Str::random( 40 )
        ] );

        $loginUrl = route( 'signin' );

        Mail::send(
            'emails.first-time',
            [
                'loginUrl' => $loginUrl,
                'userName' => $user->fname,
            ],

            function ( $message ) use ( $user ) {
                $message->to( $user->email )
                ->subject( 'Welcome to Majik Water IoT Web! - Account Creation' );
            }
        );

        return redirect()->route( 'userlist' )->withSuccess( 'User added successfully' );

    }
    public function getUser($id)
{
    $user = User::findOrFail($id);
    return response()->json($user);
}

/**
 * Update user data
 */
public function updateUser(Request $request, $id)
{
    $validated = $request->validate([
        'fname' => 'required|string|max:255',
        'lname' => 'required|string|max:255',
        'dept' => 'required|string',
        'phone' => 'required|string|max:255',
        'email' => 'required|email|unique:users,email,'.$id,
        'role' => 'required|string',
    ]);

    $user = User::findOrFail($id);
    $user->update($validated);

    return response()->json([
        'success' => true,
        'message' => 'User updated successfully'
    ]);
}

/**
 * Delete user
 */
public function deleteUser($id)
{
    $user = User::findOrFail($id);
    $user->delete();

    return response()->json([
        'success' => true,
        'message' => 'User deleted successfully'
    ]);
}


}
