<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Order;
use Illuminate\Support\Facades\Mail;


class OrderController extends Controller
{
    // public function store(Request $request)
    // {
    //     $request->validate([
    //         'phone' => 'required|string',
    //         'email' => 'required|email',
    //         'county' => 'required|string',
    //         'town_city' => 'required|string',
    //         'state_county' => 'required|string',
    //         'names'=> 'required|string'
            
    //     ]);

    //     $orderId = 'MAJIK25' . strtoupper(bin2hex(random_bytes(5))); 


    //     $order = Order::create([
    //         'names' => $request->names,
    //         'phone' => $request->phone,
    //         'email' => $request->email,
    //         'county' => $request->county,
    //         'street_address' => $request->street_address,
    //         'house_number_street_name' => $request->street_address,
    //         'apartment_suite_unit' => $request->apartment_suite_unit,
    //         'town_city' => $request->town_city,
    //         'state_county' => $request->state_county,
    //         'postcode_zip' => $request->postcode_zip,
    //         'order_id' => $orderId,
    //         'product_id' => $request->product_id,
    //         'product_price' => $request->product_price,
    //     ]);

      
    //     //send email//
    //     Mail::send(
    //         'emails.purchase-made',
    //         [ 'orderId' =>  $orderId,
    //         'productName' => $request->product_name,
    //         'custNames'=> $request->names
    //     ],
    //         function ($message) use ($request) {
    //             $message->to($request->email)
    //                 ->subject('Order successfully made');
    //         }
    //     );

    //     return redirect()->route('products')->with('success', 'Product added successfully.');

        


    // }

    public function store(Request $request)
{
    $request->validate([
        'phone' => 'required|string',
        'email' => 'required|email',
        'county' => 'required|string',
        'town_city' => 'required|string',
        'state_county' => 'required|string',
        'names'=> 'required|string'
    ]);

    $orderId = 'MAJIK25' . strtoupper(bin2hex(random_bytes(5))); 

    $order = Order::create([
        'names' => $request->names,
        'phone' => $request->phone,
        'email' => $request->email,
        'county' => $request->county,
        'street_address' => $request->street_address,
        'house_number_street_name' => $request->street_address,
        'apartment_suite_unit' => $request->apartment_suite_unit,
        'town_city' => $request->town_city,
        'state_county' => $request->state_county,
        'postcode_zip' => $request->postcode_zip,
        'order_id' => $orderId,
        'product_id' => $request->product_id,
        'product_price' => $request->product_price,
    ]);

    // Send email to customer
    Mail::send(
        'emails.purchase-made',
        [ 
            'orderId' => $orderId,
            'productName' => $request->product_name,
            'custNames'=> $request->names
        ],
        function ($message) use ($request) {
            $message->to($request->email)
                ->subject('Order successfully made');
        }
    );

    Mail::send(
        'emails.admin-purchase-notification', 
        [
            'orderId' => $orderId,
            'productName' => $request->product_name,
            'productPrice' => $request->product_price,
            'custNames' => $request->names,
            'custEmail' => $request->email,
            'custPhone' => $request->phone,
            'shippingInfo' => [
                'county' => $request->county,
                'town_city' => $request->town_city,
                'address' => $request->street_address,
                'postcode' => $request->postcode_zip
            ]
        ],
        function ($message) {
            $message->to('info@majikwater.africa')
                ->subject('New Purchase Notification - Order #' . $orderId);
        }
    );

    return redirect()->route('products')->with('success', 'Product added successfully.');
}

    public function getOrders(){

        $orders = Order::all();
        return response()->json($orders);
     }
}
