<?php $page="index";?>
@extends('layout.mainlayout')
@section('content')
<div class="page-wrapper">
    @if (!empty($showModal) && $showModal === true)
        <!-- Password Modal -->
        <div class="modal fade" id="setPasswordModal" tabindex="-1" aria-labelledby="setPasswordModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="setPasswordModalLabel">Set Your Password</h5>
                    </div>
                    <div class="modal-body">
                        <form action="{{route('set-password')}}" method="POST" id="setPasswordForm">
                            @csrf
                            <div class="mb-3">
                                <label for="newPassword" class="form-label">New Password</label>
                                <input type="password" class="form-control" id="newPassword" name="password" required>
                            </div>
                            <div class="mb-3">
                                <label for="confirmPassword" class="form-label">Confirm Password</label>
                                <input type="password" class="form-control" id="confirmPassword" name="password_confirmation" required>
                            </div>
                            <button type="submit" class="btn btn-primary w-100">Set Password</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Trigger the modal using JavaScript -->
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                var modalElement = document.getElementById('setPasswordModal');
                var modal = new bootstrap.Modal(modalElement, {
                    keyboard: false, // Disable closing with keyboard
                    backdrop: 'static' // Disable clicking outside to close
                });

                modal.show();

                // Handle form submission and password confirmation validation
                var form = document.getElementById('setPasswordForm');
                form.addEventListener('submit', function (e) {
                    var newPassword = document.getElementById('newPassword').value;
                    var confirmPassword = document.getElementById('confirmPassword').value;

                    if (newPassword !== confirmPassword) {
                        e.preventDefault(); // Prevent form submission if passwords don't match
                        alert('Passwords do not match. Please try again.');
                    } else {
                        modal.hide(); // Close the modal if passwords match
                    }
                });
            });
        </script>
    @endif





    <div class="content">
        <div class="row">
            <div class="col-lg-3 col-sm-6 col-12">
                <div class="dash-widget">
                    <div class="dash-widgetimg">
                        <span><img src="{{ URL::asset('/assets/img/icons/dash1.svg')}}" alt="img"></span>
                    </div>
                    <div class="dash-widgetcontent">
                        <h5 ><span class="counters" data-count="307144.00"></span></h5>
                        <h6>Some info metric</h6>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-12">
                <div class="dash-widget dash1">
                    <div class="dash-widgetimg">
                        <span><img src="{{ URL::asset('/assets/img/icons/dash2.svg')}}" alt="img"></span>
                    </div>
                    <div class="dash-widgetcontent">
                        <h5 ><span class="counters" data-count="4385.00">$4,385.00</span></h5>
                        <h6>Some info metric</h6>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-12">
                <div class="dash-widget dash2">
                    <div class="dash-widgetimg">
                        <span><img src="{{ URL::asset('/assets/img/icons/dash3.svg')}}" alt="img"></span>
                    </div>
                    <div class="dash-widgetcontent">
                        <h5 ><span class="counters" data-count="385656.50">385,656.50</span></h5>
                        <h6>Some info metric</h6>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-12">
                <div class="dash-widget dash3">
                    <div class="dash-widgetimg">
                        <span><img src="{{ URL::asset('/assets/img/icons/dash4.svg')}}" alt="img"></span>
                    </div>
                    <div class="dash-widgetcontent">
                        <h5 ><span class="counters" data-count="400.00">40990.00</span></h5>
                        <h6>Some info metric</h6>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">Sample Data</h5>
                    </div>
                    <div class="card-body">
                        <div id="s-line" class="chart-set"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">Sample Data</h5>
                    </div>
                    <div class="card-body">
                        <div id="donut-chart" class="chart-set"></div>
                    </div>
                </div>
            </div>

        </div>


        <div class="row">
            <div class="col-lg-7 col-sm-12 col-12 d-flex">
                <div class="card flex-fill">
                    <div class="card-header pb-0 d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">Status Tracking</h5>
                        <div class="graph-sets">
                            <ul>
                                <li>
                                    <span>Sales</span>
                                </li>
                                <li>
                                    <span>Purchase</span>
                                </li>
                            </ul>
                            <div class="dropdown">
                                <button class="btn btn-white btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                    2022 <img src="{{ URL::asset('/assets/img/icons/dropdown.svg')}}" alt="img" class="ms-2">
                                </button>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <li>
                                        <a href="javascript:void(0);" class="dropdown-item">2022</a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);" class="dropdown-item">2021</a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);" class="dropdown-item">2020</a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                    </div>
                    <div class="card-body">
                        <div id="sales_charts"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 col-sm-12 col-12 d-flex">
                <div class="card flex-fill">
                    <div class="card-header pb-0 d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">Recently Added Devices</h4>
                        <div class="dropdown">
                            <a href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class="dropset">
                                <i class="fa fa-ellipsis-v"></i>
                            </a>
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton" >
                                <li>
                                    <a href="{{url('productlist')}}" class="dropdown-item">Product List</a>
                                </li>
                                <li>
                                    <a href="{{url('addproduct')}}" class="dropdown-item">Product Add</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive dataview">
                            <table class="table datatable ">
                                <thead>
                                    <tr>
                                        <th>Sno</th>
                                        <th>Products</th>
                                        <th>Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td class="productimgname">
                                            <a href="{{url('productlist')}}" class="product-img">
                                                <img src="{{ URL::asset('/assets/img/product/product22.jpg')}}" alt="product">
                                            </a>
                                            <a href="{{url('productlist')}}">Device</a>
                                        </td>
                                        <td>KES 340</td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td class="productimgname">
                                            <a href="{{url('productlist')}}" class="product-img">
                                                <img src="{{ URL::asset('/assets/img/product/product23.jpg')}}" alt="product">
                                            </a>
                                            <a href="{{url('productlist')}}">Device</a>
                                        </td>
                                        <td>KES 340</td>
                                    </tr>
                                    <tr>
                                        <td>3</td>
                                        <td class="productimgname">
                                            <a href="{{url('productlist')}}" class="product-img">
                                                <img src="{{ URL::asset('/assets/img/product/product24.jpg')}}" alt="product">
                                            </a>
                                            <a href="{{url('productlist')}}">Device</a>
                                        </td>
                                        <td>KES 340</td>
                                    </tr>
                                    <tr>
                                        <td>4</td>
                                        <td class="productimgname">
                                            <a href="{{url('productlist')}}" class="product-img">
                                                <img src="{{ URL::asset('/assets/img/product/product6.jpg')}}" alt="product">
                                            </a>
                                            <a href="{{url('productlist')}}">Device</a>
                                        </td>
                                        <td>KES 3400</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
