@extends('layouts.app')

@section('content')
<div class="dashboard">
    <div class="main-content">
        <div class="card card-with-map">
            <h3><i class="fas fa-info-circle"></i> Device Information: {{ $device->name }}</h3>
            
            <div class="data-row">
                <span class="data-label"><i class="fas fa-barcode"></i> Serial Number:</span>
                <span class="data-value">{{ $device->serial }}</span>
            </div>
            
            <div class="data-row">
                <span class="data-label"><i class="fas fa-map-marker-alt"></i> Location:</span>
                <span class="data-value">{{ $device->location }}</span>
            </div>
            
            <div class="data-row">
                <span class="data-label"><i class="fas fa-image"></i> Device Image:</span>
                <span class="data-value">
                    @if($device->image)
                    <img src="{{ asset('storage/'.$device->image) }}" alt="Device Image" style="max-width: 200px; height: auto;">
                    @else
                    No Image Available
                    @endif
                </span>
            </div>
            
            <h3 style="margin-top: 20px;"><i class="fas fa-map-marked-alt"></i> Device Location</h3>
            <div class="map-container">
                <div id="deviceMap" style="height: 300px;"></div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize the map centered on the device location
        const deviceMap = L.map('deviceMap').setView([{{ $latitude }}, {{ $longitude }}], 15);

        // Add OpenStreetMap tiles
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 19,
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(deviceMap);

        // Add marker for the device
        const deviceIcon = L.icon({
            iconUrl: 'https://cdn-icons-png.flaticon.com/512/684/684908.png',
            iconSize: [30, 30],
            iconAnchor: [15, 30],
            popupAnchor: [1, -30]
        });

        L.marker([{{ $latitude }}, {{ $longitude }}], {icon: deviceIcon}).addTo(deviceMap)
            .bindPopup(`<b>{{ $device->name }}</b><br>{{ $device->location }}`);
    });
</script>
@endsection