@extends('layouts.app')

@section('content')
<div class="card card-full">
    <h3><i class="fas fa-microchip"></i> IoT Devices List</h3>
    
    <div style="margin-bottom: 20px;">
        <a href="{{ route('devices.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Device
        </a>
    </div>

    <table class="users-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Serial</th>
                <th>Location</th>
                <th>Coordinates</th>
                <th>Image</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($devices as $device)
            <tr>
                <td>{{ $device->id }}</td>
                <td>{{ $device->name }}</td>
                <td>{{ $device->serial }}</td>
                <td>{{ $device->location }}</td>
                <td>{{ $device->latitude }}, {{ $device->longitude }}</td>
                <td>
                    @if($device->image)
                    <img src="{{ asset('storage/'.$device->image) }}" alt="Device Image" style="width: 50px; height: auto;">
                    @else
                    No Image
                    @endif
                </td>
                <td>
                    <a href="{{ route('devices.show', $device->id) }}" class="action-btn edit-btn">
                        <i class="fas fa-eye"></i> View
                    </a>
                    <form action="{{ route('devices.destroy', $device->id) }}" method="POST" style="display: inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="action-btn delete-btn" onclick="return confirm('Are you sure?')">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection