<?php $page="addproduct";?>
@extends('layout.mainlayout')
@section('content')
<div class="page-wrapper">
    <div class="content">
        @component('components.pageheader')
			@slot('title') Product Add @endslot
			@slot('title_1') Create new product @endslot
		@endcomponent
        <!-- /add -->
        <div class="card">
            <div class="card-body">
                <form action="{{ route('product.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                <div class="row">
                   <div class="col-lg-3 col-sm-6 col-12">
                       <div class="form-group">
                           <label>Product Name</label>
                           <input type="text"  name="product_name" required>
                             </div>
                         </div>
                    <div class="col-lg-3 col-sm-6 col-12">
                        <div class="form-group">
                            <label>SKU</label>
                            <input type="text"   name="product_sku" required>
                        </div>
                    </div>
                   <div class="col-lg-3 col-sm-6 col-12">
                                          <div class="form-group">
                                              <label>Price</label>
                                              <input type="number"  name="product_price" required >
                                          </div>
                                      </div>
                    <div class="col-lg-3 col-sm-6 col-12">
                        <div class="form-group">
                            <label>Quantity</label>
                            <input type="number"  name="product_count" required>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>Description</label>
                            <textarea class="form-control"  name="product_desc" required></textarea>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>	Product Image (250px by 250px)</label>
                            <div class="image-upload">
                                <input type="file"  name="product_image" required>
                                <div class="image-uploads">
                                    <img src="{{ URL::asset('/assets/img/icons/upload.svg')}}" alt="img">
                                    <h4>Drag and drop a file to upload</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                            <button type="submit" class="btn btn-submit me-2">Submit</button>

                        <a href="{{url('productlist')}}" class="btn btn-cancel">Cancel</a>
                    </div>
                </div>
            </div>
            </div>
        </div>
        <!-- /add -->
    </div>
</div>
@endsection
