<!DOCTYPE html>
<html lang="en">
  @include('web.layouts.head')

<body>

<!--== Loader Start ==-->
<div id="loader-overlay">
  <div class="loader">
    <img src="{{ asset('assets/web-new/assets/images/loader.svg')}}" width="80" alt="" style="fill: blue;">
  </div>
</div>
<!--== Loader End ==-->

<!--== Wrapper Start ==-->
<div class="wrapper">
    @include('web.header.nav')

    <!--== Header End ==-->

    <!-- Awards Section -->
    <section class="white-bg" id="awards" style="padding-top: 80px; padding-bottom: 80px;">
      <div class="container">
        <div class="row">
          <div class="col-md-12">
            <div class="section-title">
              <h3 class="mt-0 font-700">Beths Profile</h3>
              <hr class="left-line default-bg">
            </div>
            
            <!-- Beth Koigi Profile Content -->
            <div class="beth-profile">
              <!-- Hero Section -->
              <div class="beth-hero">
                <div class="profile-container">
                  <div class="profile-image">
                    <img src="{{ asset('assets/web-new/assets/images/beth.png')}}" width="80" alt="Beth Koigi" style="fill: blue;">

                  </div>
                  <div class="profile-content">
                    <h1 class="profile-title">Beth Koigi</h1>
                    <p class="profile-subtitle">CoFounder & CEO, Majik Water</p>
                    <div class="divider"></div>
                    <p>What drives us? We believe in water as a human right—a belief born from Beth's own experiences growing up in rural Kenya, where water insecurity shaped lives. Her journey is rooted in empathy: not just building a company, but crafting a movement to ensure dignity, health, and opportunity through access to clean water.</p>
                  </div>
                </div>
              </div>

              <!-- Story Section -->
              <div class="beth-section bg-light">
                <div class="container">
                  <h2>A story that's bigger than technology</h2>
                  <div class="section-content">
                    <p>In 2017, Beth cofounded Majik Water to turn an everyday phenomenon—atmospheric humidity—into lifegiving water. This isn't just innovation. It's community empowerment in motion: an offgrid solution meeting the harsh realities of climate change across Africa. It blends modern science with local understanding to create hope where it's needed most.</p>
                    <p>Under Beth's leadership, Majik Water has reached communities across the continent and has gained international recognition from UN Environment, MIT, Forbes, Fast Company, and more.</p>
                  </div>
                </div>
              </div>

              <!-- Impact Section -->
              <div class="beth-section">
                <div class="container">
                  <h2>Impact rooted in empathy</h2>
                  <div class="section-content">
                    <p>Before Majik Water, Beth launched an initiative that delivered clean water filters to over 5,000 rural Kenyan households, improving lives one family at a time. Her work is grounded in community empowerment, climate justice, and the belief that technology should serve people—not the other way around.</p>
                  </div>
                </div>
              </div>

              <!-- Global Voice Section -->
              <div class="beth-section bg-light">
                <div class="container">
                  <h2>A global voice, with strong roots</h2>
                  <div class="section-content">
                    <p>Academically, Beth is a graduate of the University of Nairobi, with a Master's degree in Project Planning and Management and a Bachelor's degree in Community Development. She also holds a Postgraduate Certificate in Exponential Technologies for Global Grand Challenges from Singularity University in California.</p>
                    <p>Her work has earned her global recognition, both individually and as CoFounder of Majik Water. Some of the honors she's received include:</p>
                    
                    <div class="honors">
                      <div class="honor-card">
                        <i class="fas fa-award"></i>
                        <h3>EDF Pulse Award Africa (2017)</h3>
                      </div>
                      <div class="honor-card">
                        <i class="fas fa-trophy"></i>
                        <h3>MIT Water Innovation Prize</h3>
                      </div>
                      <div class="honor-card">
                        <i class="fas fa-medal"></i>
                        <h3>Women in Tech Award (AWIEF)</h3>
                      </div>
                    </div>
                    
                    <p style="margin-top: 30px;">Majik Water's innovation was also featured in the Netflix documentary A Brave Blue World—alongside global changemakers like Matt Damon and Jaden Smith—highlighting the company's role in shaping the future of water access.</p>
                  </div>
                </div>
              </div>

              <!-- Quote Section -->
              <div class="beth-quote">
                <div class="container-a">
                  <blockquote>
                    "Water is a human right. No community should be left behind."
                  </blockquote>
                  <p>This simple truth guides every decision Beth makes at Majik Water—from innovation to storytelling, from rural installations to global forums.</p>
                </div>
              </div>

              <!-- Contact Form Section -->
              <div class="beth-section">
                <div class="container">
                  <h2>Get in Touch</h2>
                  <div class="section-content">
                    <p>Interested in having Beth participate in your event or visit your organization? Please fill out the form below with details about your request.</p>
                    
                    <div class="contact-form">
                      <form id="contactForm">
                        <div class="form-group">
                          <label for="name">Your Name</label>
                          <input type="text" id="name" name="name" class="form-control" required>
                        </div>
                        
                        <div class="form-group">
                          <label for="email">Email Address</label>
                          <input type="email" id="email" name="email" class="form-control" required>
                        </div>
                        
                        <div class="form-group">
                          <label for="organization">Organization</label>
                          <input type="text" id="organization" name="organization" class="form-control">
                        </div>
                        
                        <div class="form-group">
                          <label>I'm interested in:</label>
                          <div class="radio-group">
                            <div class="radio-option">
                              <input type="radio" id="speaking" name="interest" value="speaking" required>
                              <label for="speaking">Speaking Engagement</label>
                            </div>
                            <div class="radio-option">
                              <input type="radio" id="webinar" name="interest" value="webinar">
                              <label for="webinar">Webinar</label>
                            </div>
                            <div class="radio-option">
                              <input type="radio" id="podcast" name="interest" value="podcast">
                              <label for="podcast">Podcast</label>
                            </div>
                            <div class="radio-option">
                              <input type="radio" id="demo" name="interest" value="demo">
                              <label for="demo">Office Demonstration</label>
                            </div>
                          </div>
                        </div>
                        
                        <div class="form-group">
                          <label for="message">Message</label>
                          <textarea id="message" name="message" class="form-control" required></textarea>
                        </div>
                        
                        <button type="submit" class="btn">Send Message</button>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <!-- End Beth Koigi Profile Content -->
            
          </div>
        </div>
      </div>
    </section>

    <!--== Footer Start ==-->
    @include('web.layouts.footer')
    <!--== Footer End ==-->

    <!--== Go to Top  ==-->
    <a href="javascript:" id="return-to-top"><i class="icofont icofont-arrow-up"></i></a>
    <!--== Go to Top End ==-->

</div>
<!--== Wrapper End ==-->

@include('web.layouts.js')

<style>
  /* Beth Profile Variables */
  :root {
    --beth-primary: #4c93af;
    --beth-secondary: #2c8c7a;
    --beth-accent: #f39c12;
    --beth-light: #f5f9fc;
    --beth-dark: #333333;
    --beth-gray: #718096;
    --beth-light-gray: #e2e8f0;
  }
  
  /* Beth Profile Styles */
  .beth-profile {
    font-family: 'Montserrat', sans-serif;
    color: var(--beth-dark);
    line-height: 1.6;
  }

  
  .beth-hero {
    padding: 60px 0;
    background-color: white;
  }
  
  .profile-container {
    display: flex;
    flex-wrap: wrap;
    gap: 40px;
    align-items: flex-start;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
  }
  
  .profile-image {
    flex: 1;
    min-width: 300px;
    text-align: center;
  }
  
  .profile-image img {
    width: 100%;
    max-width: 350px;
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
  }
  
  .profile-content {
    flex: 2;
    min-width: 300px;
  }
  
  .profile-title {
    color: var(--beth-primary);
    margin-bottom: 10px;
    font-size: 36px;
    font-weight: 700;
  }
  
  .profile-subtitle {
    color: var(--beth-secondary);
    font-weight: 500;
    margin-bottom: 20px;
    font-size: 18px;
  }
  
  .divider {
    height: 3px;
    width: 60px;
    background: var(--beth-accent);
    margin: 25px 0;
  }
  
  /* Section Styles */
  .beth-section {
    padding: 60px 0;
  }
  
  .beth-section h2 {
    color: var(--beth-primary);
    margin-bottom: 30px;
    text-align: center;
    font-size: 32px;
    font-weight: 700;
  }
  
  .section-content {
    max-width: 800px;
    margin: 0 auto;
    font-size: 18px;
    color: var(--beth-dark);
  }
  
  .bg-light {
    background-color: #f8fafc;
  }
  
  /* Honors Section */
  .honors {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
    margin-top: 30px;
  }
  
  .honor-card {
    flex: 1;
    min-width: 250px;
    background: white;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    border-left: 4px solid var(--beth-secondary);
    text-align: center;
  }
  
  .honor-card i {
    color: var(--beth-secondary);
    font-size: 24px;
    margin-bottom: 15px;
  }
  
  .honor-card h3 {
    font-size: 18px;
    margin: 0;
  }
  
  /* Contact Form */
  .contact-form {
    background: white;
    padding: 40px;
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    margin-top: 30px;
  }
  
  .form-group {
    margin-bottom: 20px;
  }
  
  .form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 500;
    color: var(--beth-dark);
  }
  
  .form-control {
    width: 100%;
    padding: 12px 15px;
    border: 1px solid var(--beth-light-gray);
    border-radius: 6px;
    font-size: 16px;
    transition: border-color 0.3s;
  }
  
  .form-control:focus {
    border-color: var(--beth-primary);
    outline: none;
  }
  
  textarea.form-control {
    min-height: 120px;
    resize: vertical;
  }
  
  .btn {
    background: var(--beth-primary);
    color: white;
    border: none;
    padding: 12px 25px;
    border-radius: 6px;
    font-size: 16px;
    font-weight: 500;
    cursor: pointer;
    transition: background 0.3s;
  }
  
  .btn:hover {
    background: var(--beth-secondary);
  }
  
  /* Radio Button Group */
  .radio-group {
    display: flex;
    flex-wrap: wrap;
    gap: 15px;
    margin-top: 10px;
  }
  
  .radio-option {
    display: flex;
    align-items: center;
  }
  
  .radio-option input {
    margin-right: 8px;
  }
  
  /* Quote Section */
  .beth-quote {
    background-color: var(--beth-primary);
    color: var(--beth-primary);
    padding: 60px 0;
    text-align: center;
  }
  
  .beth-quote blockquote {
    font-style: italic;
    font-size: 24px;
    max-width: 800px;
    margin: 0 auto 20px;
  }
  
  /* Responsive Design */
  @media (max-width: 768px) {
    .profile-container {
      flex-direction: column;
      text-align: center;
    }
    
    .divider {
      margin: 25px auto;
    }
    
    .contact-form {
      padding: 25px;
    }
    
    .honors {
      flex-direction: column;
    }
    
    .profile-title {
      font-size: 28px;
    }
    
    .beth-section h2 {
      font-size: 26px;
    }
    
    .section-content {
      font-size: 16px;
    }
    
    .beth-quote blockquote {
      font-size: 20px;
    }
  }
</style>

<script>
  // Form submission
  $('#contactForm').on('submit', function(e) {
    e.preventDefault();
    
    // Show loading state
    const submitBtn = $(this).find('button[type="submit"]');
    const originalText = submitBtn.text();
    submitBtn.html('<i class="fas fa-spinner fa-spin"></i> Sending...').prop('disabled', true);
    
    // Get form data
    const formData = {
      name: $('#name').val(),
      email: $('#email').val(),
      organization: $('#organization').val(),
      interest: $('input[name="interest"]:checked').val(),
      message: $('#message').val()
    };
    
    // In a real implementation, you would use a server-side endpoint
    // to send the email. This is a simulation of that process.
    setTimeout(() => {
      // Simulate successful submission
      alert('Your message has been sent successfully!');
      
      // Reset form
      $('#contactForm')[0].reset();
      submitBtn.text(originalText).prop('disabled', false);
    }, 2000);
  });
</script>

</body>
</html>