<!DOCTYPE html>
<html lang="en">
  <?php echo $__env->make('web.layouts.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<body>

<!--== Loader Start ==-->
<div id="loader-overlay">
  <div class="loader">
    <img src="<?php echo e(asset('assets/web-new/assets/images/loader.svg')); ?>" width="80" alt="" style="fill: blue;">
  </div>
</div>
<!--== Loader End ==-->

<!--== Wrapper Start ==-->
<div class="wrapper">
    <?php echo $__env->make('web.header.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--== Header End ==-->

    <!--== Hero Slider Start ==-->
    <div class="remove-padding transition-none" id="home">
      <div id="rev_slider_1078_2_wrapper" class="rev_slider_wrapper fullwidthbanner-container" data-alias="classic4export" data-source="gallery" style="margin:0px auto;background-color:#000000;padding:0px;margin-top:0px;margin-bottom:0px;">
        <!-- START REVOLUTION SLIDER 5.4.1 fullwidth mode -->
        <div id="rev_slider_1078_2" class="rev_slider fullwidthabanner anno-rs" style="display:none;" data-version="5.4.1">
          <ul>
            <!-- SLIDE  -->
            <li data-index="rs-3045" data-transition="zoomout" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off" data-easein="default" data-easeout="default" data-masterspeed="default" data-rotate="0" data-saveperformance="off" data-title="" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
              <!-- MAIN IMAGE -->
              <img src="<?php echo e(asset('assets/web-new/assets/images/hero.jpg')); ?>" alt="" class="rev-slidebg" data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-kenburns="off" data-duration="20000" data-ease="Linear.easeNone" data-scalestart="100" data-scaleend="200" data-offsetstart="0 0" data-offsetend="0 0" data-rotatestart="0" data-rotateend="0">
              <!-- LAYERS -->
              <div class="hero-text-wrap">
                <div class="tp-caption NotGeneric-Title tp-resizeme" id="slide-3045-layer-1"
                  data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['-120','-180','-180','-80']"
                  data-fontsize="['76','46','46','20']"
                  data-lineheight="['76','46','46','20']"
                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-type="text"
                  data-responsive_offset="on"
                  data-frames='[{"delay":"+290","speed":2000,"frame":"0","from":"y:50px;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['center','center','center','center']"
                  data-paddingtop="[10,10,10,10]"
                  data-paddingright="[0,0,0,0]"
                  data-paddingbottom="[10,10,10,10]"
                  data-paddingleft="[0,0,0,0]" style="font-family: 'Montserrat', sans-serif;font-weight:700;">Frequently Asked Questions</div>

                <!-- LAYER NR. 2 -->
                <div class="tp-caption NotGeneric-Title tp-resizeme" id="slide-3045-layer-2"
                  data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['60','60','0','0']"
                  data-fontsize="['22','22','22','12']"
                  data-lineheight="['38','38','38','20']"
                  data-width="none"
                  data-height="none"
                  data-whitespace="nowrap"
                  data-type="text"
                  data-responsive_offset="on"
                  data-frames='[{"delay":"+490","speed":2000,"frame":"0","from":"y:50px;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['center','center','center','center']"
                  data-paddingtop="[10,10,10,10]"
                  data-paddingright="[0,0,0,0]"
                  data-paddingbottom="[10,10,10,10]"
                  data-paddingleft="[0,0,0,0]" style="font-family: 'Montserrat', sans-serif;font-weight:400;">Find answers to common questions about Majik Water</div>
              </div>
            </li>
          </ul>
          <div class="tp-bannertimer" style="height: 3px; background-color: rgba(255, 255, 255, 0.25);"></div>
        </div>
      </div>
    </div>
    <!--== Hero Slider End ==-->

    <!-- FAQs Section -->
    <section class="white-bg" id="faqs" style="padding-top: 80px; padding-bottom: 80px;">
      <div class="container">
        <div class="row">
          <div class="col-md-12">
            <div class="section-title">
              <h3 class="mt-0 font-700">Majik Water Website – Frequently Asked Questions (FAQs)</h3>
              <hr class="left-line default-bg">
            </div>
            
            <!-- Product & Technology Accordion -->
            <div class="panel-group" id="accordion">
              <div class="panel panel-default">
                <div class="panel-heading">
                  <h4 class="panel-title">
                    <a data-toggle="collapse" data-parent="#accordion" href="#product-tech">Product & Technology</a>
                  </h4>
                </div>
                <div id="product-tech" class="panel-collapse collapse in">
                  <div class="panel-body">
                    <div class="panel-group" id="product-tech-accordion">
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#product-tech-accordion" href="#faq1">
                              What is Majik Water and how does it work?
                            </a>
                          </h4>
                        </div>
                        <div id="faq1" class="panel-collapse collapse in">
                          <div class="panel-body">
                            Majik Water uses atmospheric water generation (AWG) technology to harvest clean drinking water from the air. Our machines simply suck in the air, pass the air through condensation and we get clean and safe water for drinking.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#product-tech-accordion" href="#faq2" class="collapsed">
                              Does Majik Water work in dry areas?
                            </a>
                          </h4>
                        </div>
                        <div id="faq2" class="panel-collapse collapse">
                          <div class="panel-body">
                            Yes. Our systems are designed to operate in arid and semi-arid areas with as low as 35% humidity.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#product-tech-accordion" href="#faq3" class="collapsed">
                              What types of water solutions does Majik Water offer?
                            </a>
                          </h4>
                        </div>
                        <div id="faq3" class="panel-collapse collapse">
                          <div class="panel-body">
                            We offer atmospheric water generators, filtration systems, solar-powered purification units, and water testing kits. We offer solutions regarding the need analysis of the area.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#product-tech-accordion" href="#faq4" class="collapsed">
                              How much water can a Majik Water unit produce per day?
                            </a>
                          </h4>
                        </div>
                        <div id="faq4" class="panel-collapse collapse">
                          <div class="panel-body">
                            Depending on the model, units can produce between 1,400 to 5,000 liters of water per day.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#product-tech-accordion" href="#faq5" class="collapsed">
                              What power source do the machines use?
                            </a>
                          </h4>
                        </div>
                        <div id="faq5" class="panel-collapse collapse">
                          <div class="panel-body">
                            Our systems can be powered by solar, grid electricity, or hybrid options depending on the site's energy availability but mostly we use solar on our machines.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#product-tech-accordion" href="#faq6" class="collapsed">
                              Is the water safe for drinking?
                            </a>
                          </h4>
                        </div>
                        <div id="faq6" class="panel-collapse collapse">
                          <div class="panel-body">
                            Yes. The water undergoes filtration and UV treatment to ensure it meets WHO drinking water standards.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#product-tech-accordion" href="#faq7" class="collapsed">
                              Which regions does Majik water operate in?
                            </a>
                          </h4>
                        </div>
                        <div id="faq7" class="panel-collapse collapse">
                          <div class="panel-body">
                            East Africa
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#product-tech-accordion" href="#faq8" class="collapsed">
                              What does Majik Water mean?
                            </a>
                          </h4>
                        </div>
                        <div id="faq8" class="panel-collapse collapse">
                          <div class="panel-body">
                            Maji means water in Swahili and K stands for Kuvuna in Swahili meaning harvesting.
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              
              <!-- Sales & Orders Accordion -->
              <div class="panel panel-default">
                <div class="panel-heading">
                  <h4 class="panel-title">
                    <a data-toggle="collapse" data-parent="#accordion" href="#sales-orders" class="collapsed">Sales & Orders</a>
                  </h4>
                </div>
                <div id="sales-orders" class="panel-collapse collapse">
                  <div class="panel-body">
                    <div class="panel-group" id="sales-orders-accordion">
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#sales-orders-accordion" href="#faq9" class="collapsed">
                              How can I order a Majik Water machine?
                            </a>
                          </h4>
                        </div>
                        <div id="faq9" class="panel-collapse collapse">
                          <div class="panel-body">
                            You can place an order directly through our website or contact our sales team for a quotation.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#sales-orders-accordion" href="#faq10" class="collapsed">
                              Can I get a quotation before purchasing?
                            </a>
                          </h4>
                        </div>
                        <div id="faq10" class="panel-collapse collapse">
                          <div class="panel-body">
                            Yes. Please provide your contact details, location, and the intended use, and we'll send a detailed quotation.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#sales-orders-accordion" href="#faq11" class="collapsed">
                              Is delivery included in the price?
                            </a>
                          </h4>
                        </div>
                        <div id="faq11" class="panel-collapse collapse">
                          <div class="panel-body">
                            Delivery fees are calculated based on location and included in the final quotation.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#sales-orders-accordion" href="#faq12" class="collapsed">
                              What are the payment options?
                            </a>
                          </h4>
                        </div>
                        <div id="faq12" class="panel-collapse collapse">
                          <div class="panel-body">
                            We accept MPESA via our till, bank transfers, and PayPal. For larger units, we also offer rental and installment plans depending on our agreement.
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              
              <!-- Maintenance & Support Accordion -->
              <div class="panel panel-default">
                <div class="panel-heading">
                  <h4 class="panel-title">
                    <a data-toggle="collapse" data-parent="#accordion" href="#maintenance" class="collapsed">Maintenance & Support</a>
                  </h4>
                </div>
                <div id="maintenance" class="panel-collapse collapse">
                  <div class="panel-body">
                    <div class="panel-group" id="maintenance-accordion">
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#maintenance-accordion" href="#faq13" class="collapsed">
                              Do you provide installation services?
                            </a>
                          </h4>
                        </div>
                        <div id="faq13" class="panel-collapse collapse">
                          <div class="panel-body">
                            Yes. Our technicians handle installation and offer free user training on our AWG machines.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#maintenance-accordion" href="#faq14" class="collapsed">
                              What kind of maintenance is required?
                            </a>
                          </h4>
                        </div>
                        <div id="faq14" class="panel-collapse collapse">
                          <div class="panel-body">
                            Routine filter changes and cleaning are required. We provide manuals and offer optional maintenance contracts.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#maintenance-accordion" href="#faq15" class="collapsed">
                              Where can I get spare parts?
                            </a>
                          </h4>
                        </div>
                        <div id="faq15" class="panel-collapse collapse">
                          <div class="panel-body">
                            Spare parts can be ordered through our website.
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              
              <!-- Impact & Donations Accordion -->
              <div class="panel panel-default">
                <div class="panel-heading">
                  <h4 class="panel-title">
                    <a data-toggle="collapse" data-parent="#accordion" href="#impact" class="collapsed">Impact & Donations</a>
                  </h4>
                </div>
                <div id="impact" class="panel-collapse collapse">
                  <div class="panel-body">
                    <div class="panel-group" id="impact-accordion">
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#impact-accordion" href="#faq16" class="collapsed">
                              How can I support Majik Water's mission?
                            </a>
                          </h4>
                        </div>
                        <div id="faq16" class="panel-collapse collapse">
                          <div class="panel-body">
                            We welcome support through donations, full unit deployments, partnerships, and volunteer engagements. Each contribution helps us extend our reach and enhance our impact on global water scarcity.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#impact-accordion" href="#faq17" class="collapsed">
                              Where do donations go?
                            </a>
                          </h4>
                        </div>
                        <div id="faq17" class="panel-collapse collapse">
                          <div class="panel-body">
                            Donations fund installations in underserved communities, maintenance, and educational programs especially for the arid, semi-arid areas or areas that have been hit by disaster.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#impact-accordion" href="#faq18" class="collapsed">
                              Is there a way to track the impact of my donation?
                            </a>
                          </h4>
                        </div>
                        <div id="faq18" class="panel-collapse collapse">
                          <div class="panel-body">
                            Yes. We share impact reports and updates with all donors via email and newsletters.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#impact-accordion" href="#faq19" class="collapsed">
                              Is Majik water able to deploy their systems across the globe?
                            </a>
                          </h4>
                        </div>
                        <div id="faq19" class="panel-collapse collapse">
                          <div class="panel-body">
                            We have deployed our systems in various parts of the world especially in East Africa but we are working towards how we can reach other parts of the world.
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              
              <!-- General & Contact Accordion -->
              <div class="panel panel-default">
                <div class="panel-heading">
                  <h4 class="panel-title">
                    <a data-toggle="collapse" data-parent="#accordion" href="#general" class="collapsed">General & Contact</a>
                  </h4>
                </div>
                <div id="general" class="panel-collapse collapse">
                  <div class="panel-body">
                    <div class="panel-group" id="general-accordion">
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#general-accordion" href="#faq20" class="collapsed">
                              Can I visit a Majik Water installation?
                            </a>
                          </h4>
                        </div>
                        <div id="faq20" class="panel-collapse collapse">
                          <div class="panel-body">
                            Yes. Visits can be arranged by appointment for partners, donors, and interested clients.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#general-accordion" href="#faq21" class="collapsed">
                              Do you work with schools or communities?
                            </a>
                          </h4>
                        </div>
                        <div id="faq21" class="panel-collapse collapse">
                          <div class="panel-body">
                            Yes. We partner with schools, hospitals, and community organizations to provide safe drinking water.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#general-accordion" href="#faq22" class="collapsed">
                              How can I stay informed about Majik water's projects and developments?
                            </a>
                          </h4>
                        </div>
                        <div id="faq22" class="panel-collapse collapse">
                          <div class="panel-body">
                            You can stay updated by following us on social medias especially on LinkedIn Majik Water LinkedIn, subscribing to our newsletter below, or reaching out to us directly. We regularly share insights into our projects, technological advancements, and opportunities for you to get involved.
                          </div>
                        </div>
                      </div>
                      
                      <div class="panel panel-default">
                        <div class="panel-heading">
                          <h4 class="panel-title">
                            <a data-toggle="collapse" data-parent="#general-accordion" href="#faq23" class="collapsed">
                              How can I get in touch with customer support?
                            </a>
                          </h4>
                        </div>
                        <div id="faq23" class="panel-collapse collapse">
                          <div class="panel-body">
                            Use the chatbot on our website, send a message via WhatsApp, or email us at Email: info@majikwater.africa.
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!--== Footer Start ==-->
    <?php echo $__env->make('web.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--== Footer End ==-->

    <!--== Go to Top  ==-->
    <a href="javascript:" id="return-to-top"><i class="icofont icofont-arrow-up"></i></a>
    <!--== Go to Top End ==-->

</div>
<!--== Wrapper End ==-->

<?php echo $__env->make('web.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
  /* FAQ Styles */
  .panel-group {
    margin-bottom: 30px;
  }
  
  .panel {
    border-radius: 0;
    border: none;
    box-shadow: none;
    margin-bottom: 15px;
  }
  
  .panel-heading {
    padding: 0;
    border-radius: 0;
    background: #f8f9fa;
  }
  
  .panel-title a {
    display: block;
    padding: 15px 20px;
    color: #333;
    font-size: 18px;
    font-weight: 600;
    text-decoration: none;
    position: relative;
  }
  
  .panel-title a:after {
    content: "\f107";
    font-family: 'FontAwesome';
    position: absolute;
    right: 20px;
    top: 15px;
    font-size: 18px;
    transition: all 0.3s ease;
  }
  
  .panel-title a.collapsed:after {
    content: "\f105";
  }
  
  .panel-body {
    padding: 20px;
    background: #fff;
    border: 1px solid #eee;
  }
  
  /* Nested accordion styles */
  .panel-group .panel-group {
    margin-bottom: 0;
  }
  
  .panel-group .panel {
    border-radius: 0;
    margin-bottom: 0;
    border-bottom: 1px solid #eee;
  }
  
  .panel-group .panel:last-child {
    border-bottom: none;
  }
  
  .panel-group .panel-heading {
    padding: 0;
    background: #fff;
  }
  
  .panel-group .panel-title a {
    padding: 12px 20px 12px 40px;
    font-size: 16px;
    color: #0f6979;
  }
  
  .panel-group .panel-title a:after {
    right: 20px;
    font-size: 16px;
  }
  
  .panel-group .panel-body {
    padding: 15px 20px 15px 40px;
    border: none;
  }
  
  /* Responsive adjustments */
  @media (max-width: 767px) {
    .panel-title a {
      font-size: 16px;
      padding: 12px 15px;
    }
    
    .panel-group .panel-title a {
      padding: 10px 15px 10px 30px;
      font-size: 14px;
    }
    
    .panel-group .panel-body {
      padding: 10px 15px 10px 30px;
      font-size: 14px;
    }
  }
</style>

</body>
</html><?php /**PATH /home/arvkzdhk/testsite.majikwater.africa/resources/views/web/faqs.blade.php ENDPATH**/ ?>