
<!DOCTYPE html>
<html lang="en">
<?php echo $__env->make('web.layouts.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    :root {
        --input-padding-x: 1.5rem;
        --input-padding-y: 0.75rem;
    }

    body,
    html {
        min-height: 100vh;
        overflow-y: auto;
    }

    .btn {
        font-family: 'Montserrat', sans-serif;
    }

    .btn-success {
        background-color: #0f6979;
        border-color: #0f6979;
        color: #fff;
    }

    .btn-success:hover {
        background-color: #242424;
        border-color: #242424;
        color: #fff;
    }

    .masthead2 {
        background-image: url("../img/backgroundimage.jpg");
        background-position: 50% -26px;
        background-color: #242424;
    }

    a.social-icon {
        color: #242424;
    }

    a.social-icon:hover {
        color: #c0aa83;
    }

    .social-icon {
        background-color: #ECE4C3;
        width: 80px;
        height: 80px;
        padding: 20px;
        margin: 10px;
    }

    .social-icon a {
        background-color: #B98C45;
        width: 50px;
        height: 50px;
        padding: 10px 16px;
        margin-right: 6px;
        position: relative;
        display: block;
    }

    .social-icon a:hover {
        color: #242424;
    }

    .page-section {
        padding: 2rem 0;
    }

    .main-menu {
        color: #c0aa83;
        font-family: 'Montserrat', sans-serif;
        font-size: 20px;
        font-weight: 900;
    }

    a.link-menu {
        text-decoration: none;
        color: #c0aa83;
    }

    .footer-info {
        background-color: #000;
    }

    .scroll-to-top {
        position: fixed;
        right: 15px;
        bottom: 15px;
        width: 50px;
        height: 50px;
        text-align: center;
        color: #242424;
        background: #c0aa83;
        line-height: 46px;
    }

    .scroll-to-top:focus,
    .scroll-to-top:hover {
        color: #242424;
    }

    .scroll-to-top:hover {
        color: #c0aa83;
    }

    .rounded {
        border-radius: 0.25rem !important;
    }

    .footer-title {
        color: #fff;
        font-family: 'Montserrat', sans-serif;
        font-size: 14px;
        font-weight: 300;
        line-height: 46px;
    }

    .copyright {
        color: #c0aa83;
        font-family: 'Montserrat', sans-serif;
        font-size: 14px;
        font-weight: 300;
    }

    #mainNav {
        -webkit-box-shadow: 0.05rem 1rem rgba(0, 0, 0, 0.15);
        box-shadow: 0.05rem 1rem rgba(0, 0, 0, 0.15);
        background-color: #fff;
        -webkit-transition: background-color 0.2s ease;
        transition: background-color 0.2s ease;
    }

    #mainNav .navbar-brand {
        font-family: 'Montserrat', sans-serif;
        font-weight: 700;
    }

    #mainNav .navbar-nav .nav-item .nav-link {
        color: #242424;
        font-family: 'Montserrat', sans-serif;
        font-size: 0.9rem;
        font-weight: 700;
        padding: 0.75rem 0;
    }

    .navbar-nav {
        display: -webkit-box;
        display: -ms-box;
        display: flex;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        -ms-flex-direction: column;
        flex-direction: column;
        padding-left: 0;
        margin-bottom: 0;
        list-style: none;
    }

    .nav-item .nav-link {
        padding-left: 0;
        padding-right: 0;
    }

    #mainNav .navbar-nav .nav-item .nav-link:hover {
        color: #c0aa83 !important;
    }

    li.nav-item {
        display: inline;
        padding: 10px;
    }

    .btn-light {
        background-color: #c0aa83;
        border-color: #c0aa83;
        color: #fff;
        font-family: 'Montserrat', sans-serif;
        font-size: 16px;
        font-weight: 900;
    }

    .btn-light:hover {
        background-color: #fff;
        border-color: #c0aa83;
        color: #c0aa83;
        font-family: 'Montserrat', sans-serif;
        font-size: 16px;
        font-weight: 900;
    }

    .btn-dark {
        background-color: #242424;
        border-color: #242424;
        color: #fff;
        font-family: 'Montserrat', sans-serif;
        font-size: 16px;
        font-weight: 900;
    }

    .btn-dark:hover {
        background-color: #fff;
        border-color: #242424;
        color: #242424;
        font-family: 'Montserrat', sans-serif;
        font-size: 16px;
        font-weight: 900;
    }

    .boxed {
        background-color: #c0aa83;
        height: 150px;
        margin-left: 80px;
        margin-right: 80px;
        padding-top: 15px;
        padding-left: 20px;
    }

    .subscribe-section {
        background-image: url("../img/footer_map.png");
        background-color: #242424;
    }

    .contact-heading {
        color: #c0aa83;
        font-family: 'Montserrat', sans-serif;
        font-size: 30px;
        font-weight: 300;
    }

    .contact-info {
        color: #fff;
        font-family: 'Montserrat', sans-serif;
        font-size: 18px;
    }

    a.explore-link {
        color: #fff;
        font-family: 'Montserrat', sans-serif;
        font-size: 15px;
        text-decoration: none;
    }

    a.explore-link:hover {
        color: #c0aa83;
        font-family: 'Montserrat', sans-serif;
        font-size: 15px;
        text-decoration: none;
    }

    .logo-text-white {
        color: #fff;
        font-family: 'Montserrat', sans-serif;
        font-size: 16px;
    }

    /*PRODUCT PAGE STYLING*/
    .blog-sidebar-title {
        color: #242424;
        font-family: 'Montserrat', sans-serif;
        font-size: 25px;
        font-weight: 900;
    }

    .blog-sidebar-list {
        color: #242424;
        font-family: 'Montserrat', sans-serif;
        font-size: 16px;
        font-weight: 900;
    }

    .blog-sidebar-text {
        color: #242424;
        font-family: 'Montserrat', sans-serif;
        font-size: 16px;
        font-weight: 200;
    }

    .blog-form {
        padding: 50px;
        height: 1000px;
    }

    .list-icon {
        color: #c0aa83;
    }

    .tags {
        color: #242424;
        font-family: 'Montserrat', sans-serif;
        font-size: 20px;
        font-weight: 200;
        text-align: left;
    }

    .product-sidebar-list {
        color: #242424;
    }

    .product-sidebar-list:hover {
        color: #c0aa83;
    }

    .card-title {
        color: #0f6979;
        font-family: 'Montserrat', sans-serif;
        font-weight: 900;
    }

    .card-text {
        font-family: 'Montserrat', sans-serif;
        font-size: 11px;
        text-align: left;
    }

    .price-tag {
        color: #0f6979;
        font-family: 'Montserrat', sans-serif;
        font-size: 25px;
        font-weight: 900;
    }

    .button-text {
        border-radius: 40px;
        font-family: 'Montserrat', sans-serif;
        font-size: 11px;
        font-weight: 500;
        margin-left: -90px;
    }

    .product-image {
        width: 250px;
        height: 250px;
    }
    
    /* New styles for price formatting */
    .formatted-price {
        font-family: 'Montserrat', sans-serif;
        font-size: 20px;
        font-weight: bold;
        color: #0f6979;
    }
    
    .inquiry-price {
        font-family: 'Montserrat', sans-serif;
        font-size: 20px;
        font-weight: bold;
        color: #c0aa83;
        font-style: italic;
    }
</style>

<body>
    <!--== Loader Start ==-->
    <div id="loader-overlay">
        <div class="loader">
            <img src="<?php echo e(asset('assets/web-new/assets/images/loader.svg')); ?>" width="80" alt="">
        </div>
    </div>

    <div class="wrapper">
        <?php echo $__env->make('web.header.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="fullscreen-search-overlay" id="search-overlay">
            <a href="#" class="fullscreen-close" id="fullscreen-close-button">
                <i class="icofont icofont-close"></i>
            </a>
            <div id="fullscreen-search-wrapper">
                <form method="get" id="fullscreen-searchform">
                    <input type="text" value="" placeholder="Type and hit Enter..." id="fullscreen-search-input" class="search-bar-top">
                    <i class="fullscreen-search-icon icofont icofont-search">
                        <input value="" type="submit">
                    </i>
                </form>
            </div>
        </div>
        <!--== End Top Search ==-->
        <div class="container">
            <!--== Start Atribute Navigation ==-->
            <div class="attr-nav hidden-xs sm-display-none">
                <ul>
                    <li class="side-menu">
                        <a href="#">
                            <i class="icofont icofont-navigation-menu"></i>
                        </a>
                    </li>
                    <li class="search">
                        <a href="#" id="search-button">
                            <i class="icofont icofont-search"></i>
                        </a>
                    </li>
                </ul>
            </div>
            <!--== End Atribute Navigation ==-->
        </div>

        <section class="page-section" class="dark-bg" style="background-color: white;">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 blog-form">
                        <h2 class="blog-sidebar-title">
                            <b>Cart</b>
                        </h2>
                        <hr/>
                        <p class="blog-sidebar-text">No products in the cart...</p>
                        <div>&nbsp;</div>
                        <div>&nbsp;</div>

                        <h2 class="blog-sidebar-title">
                            <b>Categories</b>
                        </h2>
                        <hr/>
                        <p class="blog-sidebar-list">
                            <b>
                                <span class="list-icon"></span>
                                AWG machines
                            </b>
                        </p>
                        <p class="blog-sidebar-list">
                            <b>
                                <span class="list-icon"></span>
                                Water Testing Kits</b>
                        </p>

                        <div>&nbsp;</div>
                        <div>&nbsp;</div>

                        <div class="input-group mb-3">
                            <input type="text" class="form-control" placeholder="Search" aria-label="Receipient's username" aria-describely="basic-addon2">
                            <div class="input-group-append">
                                <span class="input-group-text" id="basic-addon2">
                                    <i class="fa fa-search"></i>
                                </span>
                            </div>
                        </div>
                        <div>&nbsp;</div>
                        <div>&nbsp;</div>
                    </div>

                    <div class="col-lg-9" style="padding-left: 30px; margin-top: 20px;">
                        <div class="row">
                            <div class="col">
                                Showing all <?php echo e(count($products)); ?> results
                            </div>

                            <div class="col">
                                <select class="form-control">
                                    <option value="">Default Sorting</option>
                                    <option value="popularity">Sorting by popularity</option>
                                    <option value="average">Sorting by average</option>
                                    <option value="latest">Sorting by latest</option>
                                    <option value="low">Sorting by low</option>
                                    <option value="high">Sorting by high</option>
                                </select>
                            </div>
                        </div>

                        <div>&nbsp;</div>
                        <div>&nbsp;</div>
                        <div class="row">
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-sm-3 col-md-6 col-lg-4">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <img src="<?php echo e(asset($product->image_path)); ?>" alt="<?php echo e($product->name); ?>" class="product-image">
                                            <h5 class="card-title">
                                                <b><?php echo e($product->name); ?></b>
                                            </h5>
                                            <p class="card-text small"><?php echo e($product->description); ?></p>
                                            
                                            <?php if($product->price == 0): ?>
                                                <p class="inquiry-price">Inquiry Price</p>
                                            <?php else: ?>
                                                <p class="formatted-price">KES <?php echo e(number_format($product->price, 2)); ?></p>
                                            <?php endif; ?>
                                            
                                            <a href="<?php echo e(route('purchase', ['id' => $product->id])); ?>" class="btn btn-success button-text">
                                                <i class="fa fa-shopping-cart" aria-hidden="true"></i> Buy Now
                                            </a>
                                            <a href="<?php echo e(route('products-info', ['id' => $product->id])); ?>" target="_blank" class="btn btn-success button-text">
                                                <i class="fa fa-shopping-cart" aria-hidden="true"></i> View
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div>&nbsp;</div>
                        <div>&nbsp;</div>
                    </div>
                </div>
            </div>
        </section>

        <div>&nbsp;</div>
        <div>&nbsp;</div>
        <div>&nbsp;</div>

        <?php echo $__env->make('web.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--== Footer End ==-->

        <!--== Go to Top  ==-->
        <a href="javascript:" id="return-to-top">
            <i class="icofont icofont-arrow-up"></i>
        </a>
        <!--== Go to Top End ==-->
    </div>

    <?php echo $__env->make('web.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/arvkzdhk/testsite.majikwater.africa/resources/views/web/products.blade.php ENDPATH**/ ?>