<!DOCTYPE html>
<html lang="en">
<head>
  <?php echo $__env->make('web.layouts.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <style>
    /* Process Steps Styles */
    .process-steps {
      padding: 60px 0;
    }
    .process-container {
      position: relative;
    }
    .process-line {
      position: absolute;
      height: 4px;
      background: linear-gradient(90deg, #0f6979, #50e3c2);
      top: 50px;
      left: 10%;
      right: 10%;
      z-index: 1;
    }
    .step-tabs {
      display: flex;
      justify-content: space-between;
      position: relative;
      z-index: 2;
    }
    .step-tab {
      text-align: center;
      flex: 1;
      padding: 0 15px;
      cursor: pointer;
      transition: all 0.3s ease;
    }
    .step-tab.active {
      transform: translateY(-10px);
    }
    .step-number {
      width: 60px;
      height: 60px;
      background: #fff;
      border: 3px solid #0f6979;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 15px;
      font-size: 24px;
      font-weight: bold;
      color: #0f6979;
      transition: all 0.3s ease;
    }
    .step-tab.active .step-number {
      background: #0f6979;
      color: #fff;
      transform: scale(1.1);
    }
    .step-content {
      background: #fff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 5px 25px rgba(0,0,0,0.1);
      margin-top: 30px;
      display: none;
    }
    .step-content.active {
      display: block;
      animation: fadeIn 0.5s ease;
    }
    .step-text {
      color: #555;
      font-size: 16px;
      line-height: 1.6;
    }
    .step-icon {
      font-size: 40px;
      margin-bottom: 15px;
      color: #0f6979;
    }
    
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }
    
    /* Responsive Styles */
    @media (max-width: 768px) {
      .step-tabs {
        flex-direction: column;
      }
      .step-tab {
        margin-bottom: 30px;
        flex: none;
      }
      .process-line {
        display: none;
      }
      .step-content {
        margin-top: 0;
      }
    }
  </style>
</head>
<body>

<!--== Loader Start ==-->
<div id="loader-overlay">
  <div class="loader">
    <img src="assets/images/loader.svg" width="80" alt="">
  </div>
</div>
<!--== Loader End ==-->

<!--== Wrapper Start ==-->
<div class="wrapper">
  <?php echo $__env->make('web.header.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <!-- Process Steps Section -->
  <section id="process" class="white-bg process-steps">
    <div class="container">
      <div class="row">
        <div class="col-md-12 text-center">
          <h2 class="section-title">Our Water Generation Process</h2>
          <p class="section-subtitle">How we create clean drinking water from air</p>
        </div>
      </div>
      
      <div class="row mt-50">
        <div class="col-md-12 process-container">
          <div class="process-line"></div>
          <div class="step-tabs">
            <!-- Step 1 -->
            <div class="step-tab active" data-step="1">
              <div class="step-number">1</div>
              <div class="step-icon"><i class="icofont icofont-wind"></i></div>
              <h4>Air Collection</h4>
            </div>
            
            <!-- Step 2 -->
            <div class="step-tab" data-step="2">
              <div class="step-number">2</div>
              <div class="step-icon"><i class="icofont icofont-snow"></i></div>
              <h4>Condensation</h4>
            </div>
            
            <!-- Step 3 -->
            <div class="step-tab" data-step="3">
              <div class="step-number">3</div>
              <div class="step-icon"><i class="icofont icofont-filter"></i></div>
              <h4>Filtration</h4>
            </div>
            
            <!-- Step 4 -->
            <div class="step-tab" data-step="4">
              <div class="step-number">4</div>
              <div class="step-icon"><i class="icofont icofont-water-drop"></i></div>
              <h4>Mineralization</h4>
            </div>
          </div>
          
          <!-- Step Contents -->
          <div class="step-content active" data-step="1">
            <h3>Pulling Humidity from Air</h3>
            <p class="step-text">Industrial fans pull in ambient air through our system, collecting the humidity present in the atmosphere. This is the first crucial step in our water generation process.</p>
          </div>
          
          <div class="step-content" data-step="2">
            <h3>Condensation Process</h3>
            <p class="step-text">Using refrigerating gas, we cool the collected air below its dew point, causing the water vapor to condense into liquid water droplets that are collected in our system.</p>
          </div>
          
          <div class="step-content" data-step="3">
            <h3>Advanced Filtration</h3>
            <p class="step-text">The collected water passes through a reverse osmosis (R.O) filtration system to remove any potential contaminants and prevent bacterial proliferation, ensuring water purity.</p>
          </div>
          
          <div class="step-content" data-step="4">
            <h3>Essential Mineralization</h3>
            <p class="step-text">We add back essential minerals to the purified water, providing all the necessary nutrients for healthy human consumption and optimal taste.</p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <?php echo $__env->make('web.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <a href="javascript:" id="return-to-top"><i class="icofont icofont-arrow-up"></i></a>
</div>
<!--== Wrapper End ==-->

<?php echo $__env->make('web.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
  $(document).ready(function() {
    // Process steps interaction
    $('.step-tab').click(function() {
      const step = $(this).data('step');
      
      // Update active tab
      $('.step-tab').removeClass('active');
      $(this).addClass('active');
      
      // Update active content
      $('.step-content').removeClass('active');
      $(`.step-content[data-step="${step}"]`).addClass('active');
    });
    
    // Optional: Auto-advance steps
    let currentStep = 1;
    setInterval(() => {
      currentStep = currentStep < 4 ? currentStep + 1 : 1;
      $(`.step-tab[data-step="${currentStep}"]`).click();
    }, 5000);
  });
</script>

</body>
</html><?php /**PATH /Users/ephantus.odundo_1/Desktop/DESKTOP FILES/majik/majik_web/resources/views/web/tech.blade.php ENDPATH**/ ?>