<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Majik Water Locations</title>
  <link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

  <style>
    :root {
        --primary-color: #0f6979;
        --secondary-color: #2a9d8f;
        --accent-color: #e9c46a;
        --text-color: #333;
        --light-bg: #f8f9fa;
        --section-padding: 80px 0;
    }
    
    /* Navbar Styles */
    .navbar {
      background-color: white;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      position: fixed;
      width: 100%;
      top: 0;
      z-index: 1000;
      transition: all 0.3s ease;
    }
    
    .navbar-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 20px;
      max-width: 1200px;
      margin: 0 auto;
    }
    
    .navbar-brand {
      display: flex;
      align-items: center;
      text-decoration: none;
    }
    
    .logo-img {
      height: 40px;
      margin-right: 10px;
    }
    
    .brand-name {
      font-size: 1.5rem;
      font-weight: 700;
      color: var(--primary-color);
    }
    
    .navbar-links {
      display: flex;
      list-style: none;
      margin: 0;
      padding: 0;
    }
    
    .nav-item {
      margin-left: 30px;
    }
    
    .nav-link {
      text-decoration: none;
      color: var(--text-color);
      font-weight: 500;
      transition: color 0.3s ease;
      position: relative;
    }
    
    .nav-link:hover {
      color: var(--primary-color);
    }
    
    .nav-link:after {
      content: '';
      position: absolute;
      width: 0;
      height: 2px;
      background: var(--primary-color);
      bottom: -5px;
      left: 0;
      transition: width 0.3s ease;
    }
    
    .nav-link:hover:after {
      width: 100%;
    }
    
    .mobile-menu-btn {
      display: none;
      background: none;
      border: none;
      font-size: 1.5rem;
      color: var(--primary-color);
      cursor: pointer;
    }
    
    /* Hero Section */
    .hero-section {
      /* background-image: url('https://images.unsplash.com/photo-1566438480900-0609be27a4be?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80'); */
      background-size: cover;
      background-position: center;
      height: 500px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      text-align: center;
      color: white;
      padding: 0 20px;
      margin-top: 70px; /* To account for fixed navbar */
    }
    
    .hero-section h1 {
      font-size: 3rem;
      margin-bottom: 20px;
      text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
    }
    
    .hero-section p {
      font-size: 1.5rem;
      text-shadow: 1px 1px 2px rgba(0,0,0,0.5);
      max-width: 800px;
    }
    
    /* About Section */
    .about-section {
        padding: var(--section-padding);
        background-color: #fff;
    }
    
    .section-header {
        text-align: center;
        margin-bottom: 50px;
    }
    
    .section-header h2 {
        font-size: 2.5rem;
        font-weight: 700;
        color: var(--primary-color);
        margin-bottom: 15px;
        position: relative;
        display: inline-block;
    }
    
    .section-header h2:after {
        content: '';
        position: absolute;
        width: 60px;
        height: 4px;
        background-color: var(--accent-color);
        bottom: -10px;
        left: 50%;
        transform: translateX(-50%);
    }
    
    .section-header p {
        font-size: 1.1rem;
        max-width: 800px;
        margin: 0 auto;
        color: #666;
    }
    
    .about-content {
        display: flex;
        flex-wrap: wrap;
        gap: 40px;
    }
    
    .about-text {
        flex: 1;
        min-width: 300px;
    }
    
    .about-text p {
        margin-bottom: 20px;
    }
    
    .benefits-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 30px;
        margin-top: 40px;
    }
    
    .benefit-card {
        background-color: var(--light-bg);
        border-radius: 8px;
        padding: 25px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-left: 4px solid var(--primary-color);
    }
    
    .benefit-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }
    
    .benefit-card h3 {
        color: var(--primary-color);
        margin-top: 0;
        margin-bottom: 15px;
        font-size: 1.3rem;
        display: flex;
        align-items: center;
    }
    
    .benefit-card h3 i {
        margin-right: 10px;
        color: var(--accent-color);
    }
    
    .benefit-card ul {
        padding-left: 20px;
        margin: 0;
    }
    
    .benefit-card li {
        margin-bottom: 8px;
        position: relative;
    }
    
    .benefit-card li:before {
        content: '•';
        color: var(--secondary-color);
        font-weight: bold;
        display: inline-block;
        width: 1em;
        margin-left: -1em;
    }
    
    .commitment-box {
        background-color: var(--primary-color);
        color: white;
        padding: 30px;
        border-radius: 8px;
        margin-top: 50px;
        position: relative;
        overflow: hidden;
    }
    
    .commitment-box:before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 100px;
        height: 100px;
        background-color: rgba(255,255,255,0.1);
        border-radius: 50%;
        transform: translate(30%, -30%);
    }
    
    .commitment-box h3 {
        margin-top: 0;
        font-size: 1.5rem;
    }
    
    /* Map Section */
    #map { 
      height: 700px; 
      border-radius: 8px; 
      box-shadow: 0 4px 6px rgba(0,0,0,0.1); 
      margin-top: 20px;
    }
    
    .legend { 
      padding: 10px; 
      background: white; 
      border-radius: 5px; 
      box-shadow: 0 1px 5px rgba(0,0,0,0.4);
      font-family: 'Montserrat', sans-serif;
    }
    
    .legend i { 
      width: 15px; 
      height: 15px; 
      display: inline-block; 
      margin-right: 5px; 
    }
    
    .legend h4 {
      margin: 0 0 10px;
      font-size: 16px;
    }
    
    /* Footer */
    .footer {
      background-color: var(--primary-color);
      color: white;
      padding: 50px 0 20px;
      text-align: center;
    }
    
    .footer-links {
      display: flex;
      justify-content: center;
      list-style: none;
      padding: 0;
      margin-bottom: 30px;
    }
    
    .footer-link {
      margin: 0 15px;
    }
    
    .footer-link a {
      color: white;
      text-decoration: none;
      transition: opacity 0.3s ease;
    }
    
    .footer-link a:hover {
      opacity: 0.8;
    }
    
    .copyright {
      margin-top: 20px;
      font-size: 0.9rem;
      opacity: 0.8;
    }
    
    /* Responsive Styles */
    @media (max-width: 992px) {
      .navbar-links {
        display: none;
      }
      
      .mobile-menu-btn {
        display: block;
      }
      
      .hero-section h1 {
        font-size: 2.5rem;
      }
      
      .hero-section p {
        font-size: 1.2rem;
      }
    }
    
    @media (max-width: 768px) {
      .section-header h2 {
          font-size: 2rem;
      }
      
      .benefits-grid {
          grid-template-columns: 1fr;
      }
      
      .about-content {
          flex-direction: column;
      }
      
      .hero-section h1 {
        font-size: 2rem;
      }
      
      .hero-section p {
        font-size: 1.1rem;
      }
      
      #map {
        height: 500px;
      }
    }
    
    @media (max-width: 576px) {
      .navbar-container {
        padding: 10px 15px;
      }
      
      .brand-name {
        font-size: 1.2rem;
      }
      
      .hero-section {
        height: 400px;
        margin-top: 60px;
      }
      
      .hero-section h1 {
        font-size: 1.8rem;
      }
      
      .hero-section p {
        font-size: 1rem;
      }
    }
    
    /* Body Styles */
    body {
        font-family: 'Montserrat', sans-serif;
        line-height: 1.6;
        color: var(--text-color);
        margin: 0;
        padding: 0;
        background-color: #fff;
    }
    
    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 20px;
    }
    
    /* Utility Classes */
    .mt-20 { margin-top: 20px; }
    .mt-50 { margin-top: 50px; }
    .text-center { text-align: center; }
  </style>
</head>
<body>
  <section class="about-section" id="about">
    <div class="container">
        <div class="section-header">
            <h2>About Majik Water</h2>
            <p>Majik Water Community Generated Water Solutions</p>
        </div>
        
        <div class="about-content">
            <div class="about-text">
                <p>Majik Water is a company that has been actively involved in various industries, specializing in the development of modern water systems. As a building and manufacturing firm, we provide international services including sustainable applications to meet local water demands.</p>
                
                <p>Decentralized water solutions refer to community-based systems for water supply chains and other industrial applications, serving cities, villages, and communities. Sustainability is a key advantage, especially in the use of natural resources.</p>
                
                <div class="benefits-grid">
                    <div class="benefit-card">
                        <h3><i class="fas fa-tint"></i> Improved Access to Clean Water</h3>
                        <ul>
                            <li>Decentralized systems provide core communication and database access for water transfer monitoring</li>
                            <li>Systems can be regulated quickly when needed</li>
                            <li>Reduced vulnerability to supply failures or disasters</li>
                        </ul>
                    </div>
                    
                    <div class="benefit-card">
                        <h3><i class="fas fa-dollar-sign"></i> Lower Infrastructure Costs</h3>
                        <ul>
                            <li>Require less resource infrastructure than centralized systems</li>
                            <li>More affordable for markets and commercial applications</li>
                            <li>Easier to maintain and optimize localized systems</li>
                        </ul>
                    </div>
                    
                    <div class="benefit-card">
                        <h3><i class="fas fa-users"></i> Community Involvement</h3>
                        <ul>
                            <li>Local communities take ownership of their water systems</li>
                            <li>Aligns resources with community needs and fosters responsibility</li>
                            <li>Building upgrades and monitoring systems enhance sustainability</li>
                        </ul>
                    </div>
                    
                    <div class="benefit-card">
                        <h3><i class="fas fa-shield-alt"></i> Water Security</h3>
                        <ul>
                            <li>Diverse sourcing developments through the water system</li>
                            <li>Reduced reliance on potentially unreliable sources</li>
                            <li>Water treatment enables resource irrigation at multiple levels</li>
                        </ul>
                    </div>
                    
                    <div class="benefit-card">
                        <h3><i class="fas fa-adjust"></i> Local Adaptation</h3>
                        <ul>
                            <li>Customized solutions for specific groundwater scenarios</li>
                            <li>Rainwater harvesting and groundwater restoration options</li>
                            <li>Systems adjustable based on changing conditions</li>
                        </ul>
                    </div>
                    
                    <div class="benefit-card">
                        <h3><i class="fas fa-leaf"></i> Environmental Benefits</h3>
                        <ul>
                            <li>Lower carbon footprint with renewable energy systems</li>
                            <li>Minimized environmental impact on land and ecosystems</li>
                            <li>Sustainable energy solutions</li>
                        </ul>
                    </div>
                </div>
                
                <div class="commitment-box">
                    <h3>Our Commitment</h3>
                    <p>At Majik Water, we are dedicated to helping communities access clean water solutions that improve environments, create economic opportunities, and enhance resilience for future generations. Our decentralized systems provide long-term value by utilizing local structures and reducing infrastructure costs.</p>
                </div>
            </div>
        </div>
    </div>
  </section>

  <!-- Locations Section -->
  <section class="white-bg" id="locations" style="padding: 80px 0;">
    <div class="container">
      <div class="section-header">
        <h2>Our Locations</h2>
        <p>Our units are currently deployed in these locations around the world</p>
      </div>
      
      <div id="map"></div>
    </div>
  </section>

   

  <!--== Footer Start ==-->
  
  <!--== Footer End ==-->
  <script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>
  <script>
    // Initialize the map centered on Kenya
    const map = L.map('map').setView([1.2921, 36.8219], 6);
    
    // Add OpenStreetMap tiles
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
      attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
    }).addTo(map);

    // Phase Colors
    const phase1 = '#3182ce', phase2 = '#38a169', phase3 = '#d53f8c', global = '#805ad5';

    // Corrected coordinates for Kenya locations
    const locations = [
      // Kenya (Phase 1)
      { coords: [3.3167, 40.5167], color: phase1, popup: "<b>Takaba, Mandera</b>" },
      { coords: [3.7833, 35.5333], color: phase1, popup: "<b>Loqitaung, Turkana</b>" },
      { coords: [2.3333, 35.8500], color: phase1, popup: "<b>Turkwell, Turkana</b>" },
      { coords: [3.3000, 37.0667], color: phase1, popup: "<b>North Horr, Marsabit</b>" },
      { coords: [-1.0333, 37.0833], color: phase1, popup: "<b>Thika, Ngoriba</b>" },
      { coords: [-1.3167, 36.7833], color: phase1, popup: "<b>Kibera, Nairobi</b>", radius: 10 },
      { coords: [3.5167, 39.0500], color: phase1, popup: "<b>Moyale</b>" },
      { coords: [-1.2500, 37.2500], color: phase1, popup: "<b>Kabati</b>" },
      { coords: [3.7167, 34.8667], color: phase1, popup: "<b>Kakuma, Turkana</b>" },
      { coords: [-2.2500, 40.9000], color: phase1, popup: "<b>Lamu Manda Island</b>" },
      { coords: [-4.1833, 39.4500], color: phase1, popup: "<b>Kwale</b>" },
      
      // Uganda (Phase 2)
      { coords: [3.4667, 31.2500], color: phase2, popup: "<b>Yumbe, Uganda</b>" },
      
      // Pan-Africa (Phase 3)
      { coords: [-33.9253, 18.4239], color: phase3, popup: "<b>Cape Town, South Africa</b>" },
      { coords: [-33.9253, 17.4239], color: phase3, popup: "<b>Cape Town, South Africa</b>" },

      
      // Global
      { coords: [19.0760, 72.8777], color: global, popup: "<b>Mumbai, India</b>" },
      { coords: [51.5074, -0.1278], color: global, popup: "<b>London, UK</b>" }
    ];

    // Add markers for each location
    locations.forEach(loc => {
      L.circleMarker(loc.coords, { 
        color: loc.color,
        fillColor: loc.color,
        fillOpacity: 0.8,
        radius: loc.radius || 8
      }).bindPopup(loc.popup).addTo(map);
    });

    // Add legend
    const legend = L.control({ position: 'bottomright' });
    
    legend.onAdd = function() {
      let div = L.DomUtil.create('div', 'legend');
      div.innerHTML = `
        <h4>Legend</h4>
        <i style="background:${phase1}"></i> Phase 1: Kenya<br>
        <i style="background:${phase2}"></i> Phase 2: East Africa<br>
        <i style="background:${phase3}"></i> Phase 3: Pan-Africa<br>
        <i style="background:${global}"></i> Global
      `;
      return div;
    };
    
    legend.addTo(map);

    // Mobile menu toggle
    const mobileMenuBtn = document.getElementById('mobileMenuBtn');
    const navbarLinks = document.getElementById('navbarLinks');
    
    mobileMenuBtn.addEventListener('click', () => {
      navbarLinks.style.display = navbarLinks.style.display === 'flex' ? 'none' : 'flex';
    });
    
    // Close mobile menu when clicking on a link
    document.querySelectorAll('.nav-link').forEach(link => {
      link.addEventListener('click', () => {
        if (window.innerWidth <= 992) {
          navbarLinks.style.display = 'none';
        }
      });
    });
    
    // Make navbar sticky and change style on scroll
    window.addEventListener('scroll', () => {
      const navbar = document.querySelector('.navbar');
      if (window.scrollY > 50) {
        navbar.style.boxShadow = '0 2px 10px rgba(0,0,0,0.2)';
      } else {
        navbar.style.boxShadow = '0 2px 10px rgba(0,0,0,0.1)';
      }
    });
  </script>
</body>
</html><?php /**PATH /Users/ephantus.odundo_1/Desktop/DESKTOP FILES/majik/majik_web/resources/views/web/about.blade.php ENDPATH**/ ?>