<style>
  @import url('https://fonts.googleapis.com/css?family=Roboto+Condensed:400,700');

  body {
    background: url('http://all4desktop.com/data_images/original/4236532-background-images.jpg');
    font-family: 'Roboto Condensed', sans-serif;
    color: #262626;
    margin: 5% 0;
  }

  .container {
    width: 100%;
    padding-right: 15px;
    padding-left: 15px;
    margin-right: auto;
    margin-left: auto;
  }

  @media (min-width: 1200px) {
    .container {
      max-width: 1140px;
    }
  }

  .d-flex {
    display: flex;
    flex-direction: row;
    background: #f6f6f6;
    border-radius: 0 0 5px 5px;
    padding: 25px;
  }

  form {
    flex: 4;
  }

  .Yorder {
    flex: 2;
  }

  .title {
    background: -webkit-gradient(linear, left top, right bottom, color-stop(0, #5195A8), color-stop(100, #70EAFF));
    background: -moz-linear-gradient(top left, #5195A8 0%, #e6f8f9 100%);
    background: -ms-linear-gradient(top left, #5195A8 0%, #e6f8f9 100%);
    background: -o-linear-gradient(top left, #5195A8 0%, #e6f8f9 100%);
    background: linear-gradient(to bottom right, #5195A8 0%, #e6f8f9 100%);
    border-radius: 5px 5px 0 0;
    padding: 20px;
    color: #f6f6f6;
  }

  h2 {
    margin: 0;
    padding-left: 15px;
  }

  .required {
    color: red;
  }

  label,
  table {
    display: block;
    margin: 15px;
  }

  label>span {
    float: left;
    width: 25%;
    margin-top: 12px;
    padding-right: 10px;
  }

  input[type="text"],
  input[type="tel"],
  input[type="email"],
  select {
    width: 70%;
    height: 30px;
    padding: 5px 10px;
    margin-bottom: 10px;
    border: 1px solid #dadada;
    color: #888;
  }

  select {
    width: 72%;
    height: 45px;
    padding: 5px 10px;
    margin-bottom: 10px;
  }

  .Yorder {
    margin-top: 15px;
    height: 600px;
    padding: 20px;
    border: 1px solid #dadada;
  }

  table {
    margin: 0;
    padding: 0;
  }

  th {
    border-bottom: 1px solid #dadada;
    padding: 10px 0;
  }

  tr>td:nth-child(1) {
    text-align: left;
    color: #2d2d2a;
  }

  tr>td:nth-child(2) {
    text-align: right;
    color: #52ad9c;
  }

  td {
    border-bottom: 1px solid #dadada;
    padding: 25px 25px 25px 0;
  }

  p {
    display: block;
    color: #888;
    margin: 0;
    padding-left: 25px;
  }

  .Yorder>div {
    padding: 15px 0;
  }

  button {
    width: 100%;
    margin-top: 10px;
    padding: 10px;
    border: none;
    width: 60%;
    margin-left: 200px;
    border-radius: 30px;
    background: #52ad9c;
    color: #fff;
    font-size: 15px;
    font-weight: bold;
  }

  button:hover {
    cursor: pointer;
    background: #428a7d;
  }
</style>
<div class="container">
  <div class="title">
    <h2>Majik Water Order Form</h2>
  </div>

  <div class="d-flex">
    <form action="<?php echo e(route('orders')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <label>
        <span class="fname">Full Names <span class="required">*</span></span>
        <input type="text" name="names">
      </label>
      <label>
        <span>Phone <span class="required">*</span></span>
        <input type="tel" name="phone">
      </label>
      <label>
        <span>Email Address <span class="required">*</span></span>
        <input type="email" name="email">
      </label>
      <label>
        <span>County <span class="required">*</span></span>
        <select name="county">
          <option value="select">Select a county...</option>
          <option value="Baringo">Baringo</option>
          <option value="Bomet">Bomet</option>
          <option value="Bungoma">Bungoma</option>
          <option value="Busia">Busia</option>
          <option value="Elgeyo-Marakwet">Elgeyo-Marakwet</option>
          <option value="Embu">Embu</option>
          <option value="Garissa">Garissa</option>
          <option value="Homa Bay">Homa Bay</option>
          <option value="Isiolo">Isiolo</option>
          <option value="Kajiado">Kajiado</option>
          <option value="Kakamega">Kakamega</option>
          <option value="Kericho">Kericho</option>
          <option value="Kiambu">Kiambu</option>
          <option value="Kilifi">Kilifi</option>
          <option value="Kirinyaga">Kirinyaga</option>
          <option value="Kisii">Kisii</option>
          <option value="Kisumu">Kisumu</option>
          <option value="Kitui">Kitui</option>
          <option value="Kwale">Kwale</option>
          <option value="Laikipia">Laikipia</option>
          <option value="Lamu">Lamu</option>
          <option value="Machakos">Machakos</option>
          <option value="Makueni">Makueni</option>
          <option value="Mandera">Mandera</option>
          <option value="Meru">Meru</option>
          <option value="Migori">Migori</option>
          <option value="Marsabit">Marsabit</option>
          <option value="Murang'a">Murang'a</option>
          <option value="Nairobi">Nairobi</option>
          <option value="Nakuru">Nakuru</option>
          <option value="Nandi">Nandi</option>
          <option value="Narok">Narok</option>
          <option value="Nyamira">Nyamira</option>
          <option value="Nyandarua">Nyandarua</option>
          <option value="Nyeri">Nyeri</option>
          <option value="Samburu">Samburu</option>
          <option value="Siaya">Siaya</option>
          <option value="Taita-Taveta">Taita-Taveta</option>
          <option value="Tana River">Tana River</option>
          <option value="Tharaka-Nithi">Tharaka-Nithi</option>
          <option value="Trans Nzoia">Trans Nzoia</option>
          <option value="Turkana">Turkana</option>
          <option value="Uasin Gishu">Uasin Gishu</option>
          <option value="Vihiga">Vihiga</option>
          <option value="Wajir">Wajir</option>
          <option value="West Pokot">West Pokot</option>
        </select>
      </label>



      <label>
        <span>Street Address <span class="required">*</span></span>
        <input type="text" name="street_address" placeholder="House number and street name" required>
      </label>
      <label>
        <span>&nbsp;</span>
        <input type="text" name="apartment_suite_unit" placeholder="Apartment, suite, unit etc. (optional)">
      </label>
      <label>
        <span>Town / City <span class="required">*</span></span>
        <input type="text" name="town_city">
      </label>
      <label>
        <span>State / County <span class="required">*</span></span>
        <input type="text" name="state_county">
      </label>
      <label>
        <span>Postcode / ZIP <span class="required">*</span></span>
        <input type="text" name="postcode_zip">
      </label>
      <input type="hidden" name="product_id" value=<?php echo e($product->id); ?> />
      <input type="hidden" name="product_price" value=<?php echo e($product->price); ?> />
      <input type="hidden" name="product_name" value=<?php echo e($product->name); ?> />

      

      <button type="submit">Place Order</button>

    </form>
    <div class="Yorder">

   
      <table>
        <tr>
          <th colspan="2">Your order Information</th>
        </tr>
        <tr>
          <td><?php echo e($product->name); ?></td>
          <td>KES <?php echo e($product->price); ?></td>
        </tr>
        <tr>
          <td>Subtotal</td>
          <td>KES <?php echo e($product->price); ?></td>
        </tr>
        <tr>
          <td>Shipping</td>
          <td>Free shipping</td>
        </tr>
      </table><br>
      
      
    </div><!-- Yorder -->
  </div>
</div><?php /**PATH /Users/ephantus.odundo_1/Desktop/DESKTOP FILES/majik/majik_web/resources/views/majik/purchase.blade.php ENDPATH**/ ?>